//+------------------------------------------------------------------+
//|                                                 ZeroLag OsMA.mq4 |
//|                                    Copyright  2007, Ryan Klefas |
//|                                        http://www.metaquotes.net |
//|                                      Last Update:  June 28, 2007 |
//+------------------------------------------------------------------+
//| REQUIRES:                                                        |
//+------------------------------------------------------------------+
//| ZeroLag MACD.mq4                                                 |
//+------------------------------------------------------------------+

#property copyright "Copyright  2007, Ryan Klefas"
#property link      "rklefas@inbox.com"

#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 Orchid

//---- input parameters
extern int       FastEMA=12;
extern int       SlowEMA=24;
extern int       SignalEMA=9;

//---- buffers
double OsmaBuffer[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   IndicatorBuffers(0);
   SetIndexBuffer(0,OsmaBuffer);
   
   SetIndexStyle(0,DRAW_HISTOGRAM,EMPTY,2);
   SetIndexDrawBegin(0,SlowEMA);
   IndicatorDigits(Digits+2);


   IndicatorShortName("ZeroLag OsMA ("+FastEMA+","+SlowEMA+","+SignalEMA+")");
   SetIndexLabel(0,"ZeroLag OsMA");
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
   int limit;
   int counted_bars=IndicatorCounted();
   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;


   for(int i=0; i<limit; i++)
      OsmaBuffer[i]=main(i)-signal(i);


   return(0);
}
  
//+------------------------------------------------------------------+

//+------------------------------------------------------------------+

double main(int xx)
{  return (iCustom(NULL, 0, "ZeroLag MACD", FastEMA, SlowEMA, SignalEMA, 0, xx));  }

//+------------------------------------------------------------------+

double signal(int xx)
{  return (iCustom(NULL, 0, "ZeroLag MACD", FastEMA, SlowEMA, SignalEMA, 1, xx));  }

//+------------------------------------------------------------------+

//+------------------------------------------------------------------+

//+------------------------------------------------------------------+

//+------------------------------------------------------------------+

